<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Product Bulk Import')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Product Bulk Import')); ?></h1>

          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.product.index')); ?>" class="btn btn-primary"><i class="fas fa-list"></i> <?php echo e(__('admin.Product List')); ?></a>

            <a href="<?php echo e(route('admin.product-export')); ?>" class="btn btn-success"><i class="fas fa-file-export"></i> <?php echo e(__('admin.Export Product List')); ?></a>

            <a href="<?php echo e(route('admin.product-demo-export')); ?>" class="btn btn-primary"><i class="fas fa-file-export"></i> <?php echo e(__('admin.Demo Export')); ?></a>

            <div class="row mt-4">
                <div class="col-12">
                  <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.store-product-import')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Import File')); ?> <span class="text-danger">*</span></label>
                                    <input type="file" id="name" class="form-control-file"  name="import_file" required>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button class="btn btn-primary"><?php echo e(__('admin.Upload')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                  </div>
                </div>
          </div>

          <div class="section-body">
            <div class="card">
                <div class="card-body">
                    <table class="table">
                        <?php
                            $required = 'This Field is required';
                            $not_required = 'Not required';
                            $required_and_unique = 'This Field is required and unique';
                        ?>
                        <tr>
                            <td><?php echo e(__('Thumbnail Image')); ?></td>
                            <td><?php echo e($required); ?></td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Name')); ?></td>
                            <td><?php echo e($required); ?></td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Short Name')); ?></td>
                            <td><?php echo e($required); ?></td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Slug')); ?></td>
                            <td><?php echo e($required_and_unique); ?> , <?php echo e(__('Slug and manufacture part no both are same')); ?></td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Category Id')); ?></td>
                            <td><?php echo e($required); ?>.</td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Sub category id')); ?></td>
                            <td> Haven't any sub category please set 0</td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Child category id')); ?></td>
                            <td>Haven't any child category please set 0</td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Brand id')); ?></td>
                            <td>Haven't any child category please set 0</td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Sku')); ?></td>
                            <td><?php echo e($not_required); ?></td>
                        </tr>


                        <tr>
                            <td><?php echo e(__('Price')); ?></td>
                            <td><?php echo e($required); ?>.<?php echo e(__('Allowed only numeric value')); ?></td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Offer price')); ?></td>
                            <td><?php echo e($not_required); ?>.<?php echo e(__('You can put only numeric value')); ?></td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Quantity')); ?></td>
                            <td><?php echo e($required); ?>.<?php echo e(__('You can put only numeric value')); ?></td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Weight')); ?></td>
                            <td><?php echo e($required); ?>.<?php echo e(__('You can put only numeric value')); ?></td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Vendor Id')); ?></td>
                            <td><?php echo e($required); ?>. Haven't any seller or vendor please set 0</td>
                        </tr>


                        <tr>
                            <td><?php echo e(__('Short description')); ?></td>
                            <td><?php echo e($required); ?>.</td>
                        </tr>

                        <tr>
                            <td><?php echo e(__('Long description')); ?></td>
                            <td><?php echo e($required); ?>.</td>
                        </tr>

                    </table>
                </div>
            </div>
        </div>

        </section>
      </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\shopus\resources\views/admin/product_import.blade.php ENDPATH**/ ?>